<?php

header("Content-Type: application/json");

$action = $_GET['action'] ?? null;
$query = $_GET['query'] ?? '';
$category = $_GET['name'] ?? '';
$tag = $_GET['tag'] ?? '';
$code = $_GET['code'] ?? '';

$gamezopApi = 'https://pub.gamezop.com/v3/games?id=6934';

// Always fetch fresh data (no cache)
$response = file_get_contents($gamezopApi);
$data = json_decode($response, true);

if (!$data || !isset($data['games'])) {
    echo json_encode(['error' => 'Unable to fetch game data']);
    exit;
}

$games = $data['games'];

switch ($action) {
    case 'search':
        echo json_encode(searchGames($games, $query));
        break;

    case 'category':
        echo json_encode(categoryGames($games, $category));
        break;

    case 'tag':
        echo json_encode(tagGames($games, $tag));
        break;

    case 'all':
        echo json_encode($games);
        break;

    case 'list-categories':
        echo json_encode(listCategories($games));
        break;

    case 'list-tags':
        echo json_encode(listTags($games));
        break;

    case 'game-details':
        echo json_encode(getGameDetails($games, $code));
        break;

    default:
        echo json_encode([
            'message' => '🎮 Welcome to AllGame API',
            'endpoints' => [
                'Search games' => '/api.php?action=search&query=pop',
                'Category games' => '/api.php?action=category&name=Puzzle%20%26%20Logic',
                'Tag games' => '/api.php?action=tag&tag=arcade',
                'All games' => '/api.php?action=all',
                'All categories' => '/api.php?action=list-categories',
                'All tags' => '/api.php?action=list-tags',
                'Game details by code' => '/api.php?action=game-details&code=SJX7TGkDq1X'
            ]
        ]);
        break;
}

function searchGames($games, $query) {
    $query = strtolower($query);
    return array_values(array_filter($games, function($game) use ($query) {
        return strpos(strtolower($game['name']['en']), $query) !== false ||
               strpos(strtolower($game['description']['en']), $query) !== false;
    }));
}

function categoryGames($games, $category) {
    $category = strtolower($category);
    return array_values(array_filter($games, function($game) use ($category) {
        return in_array($category, array_map('strtolower', $game['categories']['en']));
    }));
}

function tagGames($games, $tag) {
    $tag = strtolower($tag);
    return array_values(array_filter($games, function($game) use ($tag) {
        return in_array($tag, array_map('strtolower', $game['tags']['en']));
    }));
}

function listCategories($games) {
    $all = [];
    foreach ($games as $game) {
        if (!empty($game['categories']['en'])) {
            foreach ($game['categories']['en'] as $cat) {
                $all[] = $cat;
            }
        }
    }
    return array_values(array_unique($all));
}

function listTags($games) {
    $all = [];
    foreach ($games as $game) {
        if (!empty($game['tags']['en'])) {
            foreach ($game['tags']['en'] as $t) {
                $all[] = $t;
            }
        }
    }
    return array_values(array_unique($all));
}

function getGameDetails($games, $code) {
    foreach ($games as $game) {
        if ($game['code'] === $code) {
            return $game;
        }
    }
    return ['error' => 'Game not found with code: ' . $code];
}
